using UnityEngine;
using System.Collections;

public class s_Killable : MonoBehaviour
{
	[System.NonSerialized][HideInInspector]
	public AudioSource mDieSound;// Sound that plays when you die
	[System.NonSerialized][HideInInspector]
	public bool mDead = false;	// Checks if you are dead
	[System.NonSerialized][HideInInspector]
	public bool mWasDead = false;// Will check if you were dead, so when rewind ends can see if you should be dead
	
	int mDeadTime = 0;			// The time stamp for when you died
	float mDeadDelay = 1.0f;	// Delays how long the game goes when you die
	float mDelayTimer = 0;		// The actual timer
	float mDeadPosX = 0;		// Position where you died
	float mDeadPosY = 0;
	
	void Start()
	{
		s_TimeManager.Get.AddEndFunction(RewindEnd);
	}
	
	public void UpdateDead()
	{
		// Check if you got to the point where you died
		if (mDead && mDeadTime > s_TimeManager.sTimeStamp)
			Revive();
		
		// Check if you rewinded forward to the point where you died
		if (!mDead && mDeadTime < s_TimeManager.sTimeStamp)
			Kill();
		
		// Stop game with delay when player dies
		if (gameObject.tag == "Player" && mDead)
		{
			if (mDelayTimer >= 0 && mDelayTimer <= mDeadDelay)
			{	
				mDelayTimer += Time.deltaTime * s_TimeManager.sRewindSpeed;
				
				if (mDelayTimer >= mDeadDelay)
					Stop();
				
				// Clamp
				if (mDelayTimer < 0)
					mDelayTimer = 0;
				else if (mDelayTimer > mDeadDelay)
					mDelayTimer = mDeadDelay;
			}
		}
	}
	
	public void RewindEnd()
	{
		if (mDeadTime > s_TimeManager.sTimeStamp)
		{
			mWasDead = false;
			mDeadTime = 0;
			
			if (gameObject.tag == "Player")
				s_Player.sDead = false;
		}
		
		//Dont move the dead
		if (mDead)
			transform.position = new Vector3(mDeadPosX, mDeadPosY, transform.position.z);
	}
	
	public void Kill()
	{
		s_AudioManager.Get.PlaySound(mDieSound);
		
		// Set the timestamp of when you died
		if (mDeadTime == 0)
			mDeadTime = s_TimeManager.sTimeStamp;
		
		// Set the position of your death (if I don't save this position, it will move the dead when rewind ends.)
		mDeadPosX = transform.position.x;
		mDeadPosY = transform.position.y;
		
		// Disable collider and animations
		mDead = true;
		mWasDead = true;
		collider.enabled = false;
		DisableScripts();
	}
	
	void Revive()
	{
		// Turn on collider and animations
		mDead = false;
		collider.enabled = true;
		EnableScripts();
	}
	
	void DisableScripts()
	{
		// Disable animations (don't want any dead things moving)
		if (GetComponent<s_AnimationBase>() != null)
			GetComponent<s_AnimationBase>().Dead();
		
		// Disable rewind script (was having weird rewind issues)
		if (GetComponent<s_Rewindable>() != null)
	       	GetComponent<s_Rewindable>().enabled = false;
	}
	
	void EnableScripts()
	{
		if (GetComponent<s_AnimationBase>() != null)
			GetComponent<s_AnimationBase>().Revive();
		
		if (GetComponent<s_Rewindable>() != null)
	       	GetComponent<s_Rewindable>().enabled = true;
	}
	
	void Stop()
	{
		Time.timeScale = 0;
		s_Player.sDead = true; //Only player calls this function
	}
}
